%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Function name: calc_fit_coeff
%
% Scope:    calculate linear fit coefficients between all variables
%
% Input:    bindata (structure),
%           list of gas names (cell),
%           anchor dataset name (string)
%
% Output:   "fitcoeff" structure containing linear fit coefficients (slope,
%           intercept) between all variables
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function fitcoeff = calc_fit_coeff(bindata,gasnames,anchor_dataset)

ind=find(ismember(gasnames,anchor_dataset));
        
for i=1:width(bindata.varlabels)
    for k=1:width(bindata.varlabels)

        idx1 = isnan(bindata.(gasnames{1,ind})(:,k)); 
        idx2 = isnan(bindata.(gasnames{1,ind})(:,i));
        idx_comb = idx1 | idx2;

        fff = polyfit(bindata.(gasnames{1,ind})(~idx_comb,k),bindata.(gasnames{1,ind})(~idx_comb,i),1);

        fitcoeff.slope(i,k)=fff(1,1);
        fitcoeff.intercept(i,k)=fff(1,2);

    end
end

end